public enum ChessPiece {
    WHITEPAWN(1,1), WHITEKNIGHT(1,3), WHITEBISHOP(1,3), 
    WHITEROOK(1,5), WHITEQUEEN(1,9), WHITEKING(1,1<<30),
    BLACKPAWN(0,1), BLACKKNIGHT(0,3), BLACKBISHOP(0,3), 
    BLACKROOK(0,5), BLACKQUEEN(0,9), BLACKKING(0,1<<30);
    private int side, value;
    private ChessPiece(int side, int value) {
        this.side = side;
        this.value = value;
    }
    public int getSide() { return side; }
    public int getValue() { return value; }
    public String toString() {
        String rv;
        if (getSide() == 0) rv = "Black ";
        else rv = "White ";
        switch(getValue()) {
            case 1: return rv + "Pawn";
            case 3: 
                if (this==WHITEKNIGHT || this==BLACKKNIGHT)
                    return rv + "Knight";
                else return rv + "Bishop";
            case 5:
                return rv + "Rook";
            case 9:
                return rv + "Queen";
            case 1<<30:
                return rv + "King";
        }
        return rv;
    }
}
